package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithFavorite

@Component
class CampaignWithFavoriteCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithFavorite> {
    override fun getTypeClass() = CampaignWithFavorite::class.java

    override fun preprocess(entity: CampaignWithFavorite, copyContainer: CopyOperationContainer) {
        if (copyContainer.isCopyingBetweenClients) {
            // У нового клиента другие представители - копирование не имеет смысла
            // https://st.yandex-team.ru/DIRECT-119902#5ee237edf9f068584c16f60c
            entity.favoriteForUids = setOf()
        }
    }
}
