package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenCheckPositionEvent

@Component
class CampaignWithForbiddenCheckPositionEventCopyPreprocessor :
    CopyPreprocessorTypeSupport<CampaignWithForbiddenCheckPositionEvent> {
    override fun getTypeClass() = CampaignWithForbiddenCheckPositionEvent::class.java

    override fun preprocess(entity: CampaignWithForbiddenCheckPositionEvent, copyContainer: CopyOperationContainer) {
        // Для кампаний с интерфейсом CampaignWithForbiddenCheckPositionEvent эти поля системные,
        // и не должны задаваться при создании
        entity.enableCheckPositionEvent = null
        entity.checkPositionIntervalEvent = null
    }
}

