package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields
import ru.yandex.direct.core.entity.currency.service.CurrencyConverterFactory
import ru.yandex.direct.currency.Currencies

@Component
class CampaignWithMeaningfulGoalsCopyPreprocessor(
    private val currencyConverterFactory: CurrencyConverterFactory,
) : CopyPreprocessorTypeSupport<CampaignWithMeaningfulGoalsWithRequiredFields> {
    override fun getTypeClass() = CampaignWithMeaningfulGoalsWithRequiredFields::class.java

    override fun preprocess(
        campaign: CampaignWithMeaningfulGoalsWithRequiredFields, copyContainer: CopyOperationContainer
    ) {
        if (campaign.metrikaCounters == null) {
            campaign.metrikaCounters = listOf()
        }

        if (copyContainer.getCampaignPreprocessFlagsById(campaign.id).isDropStrategyToDefault) {
            campaign.meaningfulGoals = listOf()
        }

        if (copyContainer.isCopyingBetweenClients &&
            campaign.meaningfulGoals != null && campaign.meaningfulGoals.isNotEmpty() &&
            copyContainer.clientFrom.workCurrency != copyContainer.clientTo.workCurrency
        ) {
            val currencyTo = Currencies.getCurrency(copyContainer.clientTo.workCurrency)
            val converter = currencyConverterFactory.createConverter(
                copyContainer.clientFrom.workCurrency,
                copyContainer.clientTo.workCurrency
            )
            for (goal in campaign.meaningfulGoals) {
                if (goal.conversionValue != null) {
                    goal.conversionValue =
                        converter.convert(goal.conversionValue, currencyTo.minPrice, currencyTo.maxAutobudget)
                }
            }
        }
    }
}
