package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants

@Component
class CampaignWithNetworkSettingsCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithNetworkSettings> {
    override fun getTypeClass() = CampaignWithNetworkSettings::class.java

    override fun preprocess(entity: CampaignWithNetworkSettings, copyContainer: CopyOperationContainer) {
        // AUTO_CONTEXT_LIMIT - отсутствие значения, не пропускает валидация
        if (entity.contextLimit == CampaignConstants.AUTO_CONTEXT_LIMIT
            // SHOWS_DISABLED_CONTEXT_LIMIT - запрещены показы, валидно только при platform == SEARCH
            || (entity.contextLimit == CampaignConstants.SHOWS_DISABLED_CONTEXT_LIMIT
                    && entity.strategy.platform != CampaignsPlatform.SEARCH)
            // NO_CONTEXT_LIMIT может быть установлено только супером
            || entity.contextLimit == CampaignConstants.NO_CONTEXT_LIMIT
        ) {
            entity.contextLimit = null
        }
    }
}
