package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPhone

@Component
class CampaignWithPhoneCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithPhone> {
    override fun getTypeClass() = CampaignWithPhone::class.java

    override fun preprocess(campaign: CampaignWithPhone, copyContainer: CopyOperationContainer) {
        if (copyContainer.isCopyingBetweenClients) {
            campaign.defaultTrackingPhoneId = null
        }
    }
}
