package ru.yandex.direct.core.copyentity.prevalidators;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.copyentity.CopyValidationResultUtils;
import ru.yandex.direct.core.copyentity.EntityContext;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.dbutil.SqlUtils;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.DefectId;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.copyentity.CopyValidationResultUtils.filterDefects;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds.Gen.VIDEO_EXTENSION_NOT_FOUND;

/**
 * Осуществляет превалидацию баннеров на причины, которые могут помешать их копированию
 */
@ParametersAreNonnullByDefault
@Component
public class BannerCopyPrevalidator implements EntityPrevalidator {
    private final BannersAddOperationFactory bannersAddOperationFactory;

    private static final int VALIDATE_CHUNK_SIZE = SqlUtils.TYPICAL_SELECT_CHUNK_SIZE;

    private static final Set<DefectId<?>> FILTERED_DEFECTS = Set.of(
            VIDEO_EXTENSION_NOT_FOUND
    );

    public BannerCopyPrevalidator(BannersAddOperationFactory bannersAddOperationFactory) {
        this.bannersAddOperationFactory = bannersAddOperationFactory;
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    public ValidationResult prevalidate(EntityContext context, CopyOperationContainer copyContainer) {
        var banners = context.getObjects(BannerWithAdGroupId.class);

        List<MassResult<Long>> results = StreamEx.ofSubLists(banners, VALIDATE_CHUNK_SIZE)
                .map(chunk -> validateBannerChunk(copyContainer, chunk))
                .toList();

        MassResult<Long> mergedMassResult = CopyValidationResultUtils.mergeMassResults((List) results);

        return filterDefects(mergedMassResult.getValidationResult(), FILTERED_DEFECTS);
    }

    private MassResult<Long> validateBannerChunk(CopyOperationContainer copyContainer,
                                                 List<BannerWithAdGroupId> banners) {
        var operation = bannersAddOperationFactory.createPartialAddOperation(
                banners,
                copyContainer.getClientIdTo(),
                copyContainer.getOperatorUid(),
                true, true
        );
        return operation.prepare().orElseGet(operation::cancel);
    }

}
