package ru.yandex.direct.core.copyentity.prevalidators;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;

@Component
@ParametersAreNonnullByDefault
public class CopyPrevalidator extends Prevalidator {
    public CopyPrevalidator(AdGroupCopyPrevalidator adGroupCopyPrevalidator,
                            BannerCopyPrevalidator bannerPrevalidator,
                            RetargetingConditionCopyPrevalidator retCondPrevalidator) {
        addPrevalidator(AdGroup.class, adGroupCopyPrevalidator);
        addPrevalidator(BannerWithAdGroupId.class, bannerPrevalidator);
        addPrevalidator(RetargetingConditionBase.class, retCondPrevalidator);
    }
}
