package ru.yandex.direct.core.copyentity.prevalidators;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.copyentity.EntityContext;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.validation2.AddRetargetingConditionValidationService2;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.copyentity.CopyValidationResultUtils.filterDefects;
import static ru.yandex.direct.validation.result.DefectIds.OBJECT_NOT_FOUND;

@ParametersAreNonnullByDefault
@Component
public class RetargetingConditionCopyPrevalidator implements EntityPrevalidator {
    private AddRetargetingConditionValidationService2 retCondValidationService;

    public RetargetingConditionCopyPrevalidator(AddRetargetingConditionValidationService2 retCondValidationService) {
        this.retCondValidationService = retCondValidationService;
    }

    public ValidationResult prevalidate(EntityContext context, CopyOperationContainer copyContainer) {
        var retCondList = StreamEx.of(context.getObjects(RetargetingConditionBase.class))
                .select(RetargetingCondition.class)
                .toList();
        ValidationResult<List<RetargetingCondition>, Defect> result = retCondValidationService.validate(
                retCondList,
                copyContainer.getClientIdTo());
        return filterDefects(result, Set.of(OBJECT_NOT_FOUND));
    }
}
