package ru.yandex.direct.core.entity.abt.container;

import java.util.Collection;
import java.util.Set;

public class AllowedFeatures {

    private Set<String> allowedFeaturesSet;

    public AllowedFeatures(Set<String> allowedFeatures) {
        this.allowedFeaturesSet = allowedFeatures;
    }

    public static AllowedFeatures allAllowed() {
        return new AllowedFeatures(Set.of());
    }

    public static AllowedFeatures of(Set<String> features) {
        return new AllowedFeatures(features);
    }

    public static AllowedFeatures of(String features) {
        return new AllowedFeatures(Set.of(features));
    }

    public boolean isAllFeaturesAllowed(Collection<String> possibleFeatures) {
        return allowedFeaturesSet.isEmpty() || allowedFeaturesSet.containsAll(possibleFeatures);
    }

    public Set<String> getFeatures() {
        return allowedFeaturesSet;
    }
}
