package ru.yandex.direct.core.entity.abt.container;

import java.util.List;
import java.util.Objects;

public class TestInfo {
    private List<String> features;
    private List<String> testIds;
    private String condition;

    public TestInfo withFeatures(List<String> features) {
        this.features = features;
        return this;
    }

    public TestInfo withTestIds(List<String> testIds) {
        this.testIds = testIds;
        return this;
    }

    public TestInfo withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public List<String> getFeatures() {
        return features;
    }

    public List<String> getTestIds() {
        return testIds;
    }

    public String getCondition() {
        return condition;
    }

    public boolean hasCondition() {
        return !"".equals(condition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TestInfo testInfo = (TestInfo) o;
        return Objects.equals(features, testInfo.features) &&
                Objects.equals(testIds, testInfo.testIds) &&
                Objects.equals(condition, testInfo.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(features, testIds, condition);
    }

    @Override
    public String toString() {
        return "TestInfo{" +
                "features=" + features +
                ", testIds=" + testIds +
                ", condition='" + condition + '\'' +
                '}';
    }
}
