package ru.yandex.direct.core.entity.abt.container;

import java.util.Objects;
import java.util.Set;

public class UaasInfoRequest {
    private String yandexUid;
    private Long clientId;
    private String userAgent;
    private String host;
    private String ip;
    private String text;
    private String yexpCookie;
    private String interfaceLang;

    private Set<String> enabledFeatures;

    public String getYandexUid() {
        return yandexUid;
    }

    public Long getClientId() {
        return clientId;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public String getHost() {
        return host;
    }

    public String getIp() {
        return ip;
    }

    public String getText() {
        return text;
    }

    public String getYexpCookie() {
        return yexpCookie;
    }

    public String getInterfaceLang() {
        return interfaceLang;
    }

    public Set<String> getEnabledFeatures() {
        return enabledFeatures;
    }

    public UaasInfoRequest withYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
        return this;
    }

    public UaasInfoRequest withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public UaasInfoRequest withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UaasInfoRequest withHost(String host) {
        this.host = host;
        return this;
    }

    public UaasInfoRequest withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public UaasInfoRequest withText(String text) {
        this.text = text;
        return this;
    }

    public UaasInfoRequest withYexpCookie(String yexpCookie) {
        this.yexpCookie = yexpCookie;
        return this;
    }

    public UaasInfoRequest withInterfaceLang(String interfaceLang) {
        this.interfaceLang = interfaceLang;
        return this;
    }

    public UaasInfoRequest withEnabledFeatures(Set<String> enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UaasInfoRequest that = (UaasInfoRequest) o;
        return Objects.equals(yandexUid, that.yandexUid) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(userAgent, that.userAgent) &&
                Objects.equals(host, that.host) &&
                Objects.equals(ip, that.ip) &&
                Objects.equals(text, that.text) &&
                Objects.equals(yexpCookie, that.yexpCookie) &&
                Objects.equals(interfaceLang, that.interfaceLang) &&
                Objects.equals(enabledFeatures, that.enabledFeatures);
    }

    @Override
    public int hashCode() {
        return Objects.hash(yandexUid, clientId, userAgent, host, ip, text, yexpCookie, interfaceLang, enabledFeatures);
    }

    @Override
    public String toString() {
        return "UaasInfoRequest{" +
                "yandexUid='" + yandexUid + '\'' +
                ", clientId=" + clientId +
                ", userAgent='" + userAgent + '\'' +
                ", host='" + host + '\'' +
                ", ip='" + ip + '\'' +
                ", text='" + text + '\'' +
                ", yexpCookie='" + yexpCookie + '\'' +
                ", interfaceLang='" + interfaceLang + '\'' +
                ", enabledFeatures=" + enabledFeatures +
                '}';
    }
}
