package ru.yandex.direct.core.entity.abt.container;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import ru.yandex.direct.dbutil.model.ClientId;

public class UaasInfoResponse {
    private ClientId clientId;
    private List<String> features;
    private List<TestInfo> tests;
    private String boxes;
    private String boxesCrypted;
    private String configVersion;

    public ClientId getClientId() {
        return clientId;
    }

    public List<String> getFeatures() {
        return features;
    }

    public String getBoxes() {
        return boxes;
    }

    public String getBoxesCrypted() {
        return boxesCrypted;
    }

    public String getConfigVersion() {
        return configVersion;
    }

    public UaasInfoResponse withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    public UaasInfoResponse withBoxes(String boxes) {
        this.boxes = boxes;
        return this;
    }

    public UaasInfoResponse withBoxesCrypted(String boxesCrypted) {
        this.boxesCrypted = boxesCrypted;
        return this;
    }

    public UaasInfoResponse withConfigVersion(String configVersion) {
        this.configVersion = configVersion;
        return this;
    }

    public UaasInfoResponse withTests(List<TestInfo> tests) {
        this.tests = tests;
        this.features =
                tests.stream().flatMap(testInfo -> testInfo.getFeatures().stream()).collect(Collectors.toList());
        return this;
    }

    public List<TestInfo> getTests() {
        return tests;
    }

    @Override
    public String toString() {
        return "UaasInfoResponse{" +
                "clientId=" + clientId +
                ", tests=" + tests +
                ", boxes='" + boxes + '\'' +
                ", boxesCrypted='" + boxesCrypted + '\'' +
                ", configVersion='" + configVersion + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UaasInfoResponse that = (UaasInfoResponse) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(tests, that.tests) &&
                Objects.equals(boxes, that.boxes) &&
                Objects.equals(boxesCrypted, that.boxesCrypted) &&
                Objects.equals(configVersion, that.configVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, tests, boxes, boxesCrypted, configVersion);
    }
}
