package ru.yandex.direct.core.entity.abt.service;

import org.springframework.stereotype.Component;

import ru.yandex.direct.env.EnvironmentType;

/**
 * Класс получения имени текущего окружения
 * Используется как условие для ab экспериментов
 * Выделен в отделный класс для того, чтобы логика получения была в одном месте и общей для отчета в web и
 * UaasInfoService'а
 */
@Component
public class EnvironmentNameGetter {

    private final String environmentTypeName;

    public EnvironmentNameGetter(EnvironmentType environmentType) {
        this.environmentTypeName = environmentType.name().toLowerCase();
    }

    public String get() {
        return environmentTypeName;
    }
}
