package ru.yandex.direct.core.entity.account.score.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

import javax.annotation.Nonnull;

import ru.yandex.direct.dbschema.ppc.enums.AccountScoreType;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class AccountScore implements Model {
    public static final ModelProperty<AccountScore, Long> CLIENT_ID =
            ModelProperty.create(AccountScore.class, "clientId", AccountScore::getClientId, AccountScore::setClientId);

    public static final ModelProperty<AccountScore, LocalDate> DATE =
            ModelProperty.create(AccountScore.class, "date", AccountScore::getDate, AccountScore::setDate);

    public static final ModelProperty<AccountScore, AccountScoreFactors> FACTORS =
            ModelProperty.create(AccountScore.class, "factors", AccountScore::getFactors, AccountScore::setFactors);

    public static final ModelProperty<AccountScore, BigDecimal> SCORE =
            ModelProperty.create(AccountScore.class, "score", AccountScore::getScore, AccountScore::setScore);

    public static final ModelProperty<AccountScore, AccountScoreType> TYPE =
            ModelProperty.create(AccountScore.class, "type", AccountScore::getType, AccountScore::setType);

    @Nonnull
    private Long clientId;

    @Nonnull
    private LocalDate date;

    private AccountScoreFactors factors;

    @Nonnull
    private BigDecimal score;

    @Nonnull
    private AccountScoreType type;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public AccountScore withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public AccountScore withDate(LocalDate date) {
        this.date = date;
        return this;
    }

    public AccountScoreFactors getFactors() {
        return factors;
    }

    public void setFactors(AccountScoreFactors factors) {
        this.factors = factors;
    }

    public AccountScore withFactors(AccountScoreFactors factors) {
        this.factors = factors;
        return this;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public AccountScore withScore(BigDecimal score) {
        this.score = score;
        return this;
    }

    public AccountScoreType getType() {
        return type;
    }

    public void setType(AccountScoreType type) {
        this.type = type;
    }

    public AccountScore withType(AccountScoreType type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountScore that = (AccountScore) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(date, that.date) &&
                Objects.equals(factors, that.factors) &&
                Objects.equals(score, that.score) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, date, factors, score, type);
    }

    @Override
    public String toString() {
        return "AccountScore{" +
                "clientId=" + clientId +
                ", date=" + date +
                ", factorsJson='" + factors + '\'' +
                ", score=" + score +
                ", type=" + type +
                '}';
    }
}
