package ru.yandex.direct.core.entity.account.score.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Структура соответствующая данным которые хранятся в
 * {@link ru.yandex.direct.dbschema.ppc.tables.AccountScore#FACTORS_JSON}
 * полей выбран тип Double, чтобы защититься от изменений для тех полей где сейчас только целое число
 */
public class AccountScoreFactors {

    @JsonProperty("broadmatch_percent")
    private Double broadmatchPercent;

    @JsonProperty("shows_days_count")
    private Double showsDaysCount;

    @JsonProperty("stop_days_fine")
    private Double stopDaysFine;

    @JsonProperty("avg_banners_count")
    private Double avgBannersCount;

    @JsonProperty("avg_phrases_count")
    private Double avgPhrasesCount;

    @JsonProperty("sitelinks_percent")
    private Double sitelinksPercent;

    @JsonProperty("images_percent")
    private Double imagesPercent;

    @JsonProperty("ctx_price_coef_percent")
    private Double ctxPriceCoefPercent;

    @JsonProperty("separate_place_count")
    private Double separatePlaceCount;

    @JsonProperty("vcards_count")
    private Double vcardsCount;

    public Double getBroadmatchPercent() {
        return broadmatchPercent;
    }

    public void setBroadmatchPercent(Double broadmatchPercent) {
        this.broadmatchPercent = broadmatchPercent;
    }

    public AccountScoreFactors withBroadmatchPercent(Double broadmatchPercent) {
        setBroadmatchPercent(broadmatchPercent);
        return this;
    }

    public Double getStopDaysFine() {
        return stopDaysFine;
    }

    public void setStopDaysFine(Double stopDaysFine) {
        this.stopDaysFine = stopDaysFine;
    }

    public AccountScoreFactors withStopDaysFine(Double stopDaysFine) {
        setStopDaysFine(stopDaysFine);
        return this;
    }

    public Double getShowsDaysCount() {
        return showsDaysCount;
    }

    public void setShowsDaysCount(Double showsDaysCount) {
        this.showsDaysCount = showsDaysCount;
    }

    public AccountScoreFactors withShowsDaysCount(Double showsDaysCount) {
        setShowsDaysCount(showsDaysCount);
        return this;
    }

    public Double getAvgBannersCount() {
        return avgBannersCount;
    }

    public void setAvgBannersCount(Double avgBannersCount) {
        this.avgBannersCount = avgBannersCount;
    }

    public AccountScoreFactors withAvgBannersCount(Double avgBannersCount) {
        setAvgBannersCount(avgBannersCount);
        return this;
    }

    public Double getAvgPhrasesCount() {
        return avgPhrasesCount;
    }

    public void setAvgPhrasesCount(Double avgPhrasesCount) {
        this.avgPhrasesCount = avgPhrasesCount;
    }

    public AccountScoreFactors withAvgPhrasesCount(Double avgPhrasesCount) {
        setAvgPhrasesCount(avgPhrasesCount);
        return this;
    }

    public Double getSitelinksPercent() {
        return sitelinksPercent;
    }

    public void setSitelinksPercent(Double sitelinksPercent) {
        this.sitelinksPercent = sitelinksPercent;
    }

    public AccountScoreFactors withSitelinksPercent(Double sitelinksPercent) {
        setSitelinksPercent(sitelinksPercent);
        return this;
    }

    public Double getImagesPercent() {
        return imagesPercent;
    }

    public void setImagesPercent(Double imagesPercent) {
        this.imagesPercent = imagesPercent;
    }

    public AccountScoreFactors withImagesPercent(Double imagesPercent) {
        setImagesPercent(imagesPercent);
        return this;
    }

    public Double getCtxPriceCoefPercent() {
        return ctxPriceCoefPercent;
    }

    public void setCtxPriceCoefPercent(Double ctxPriceCoefPercent) {
        this.ctxPriceCoefPercent = ctxPriceCoefPercent;
    }

    public AccountScoreFactors withCtxPriceCoefPercent(Double ctxPriceCoefPercent) {
        setCtxPriceCoefPercent(ctxPriceCoefPercent);
        return this;
    }

    public Double getSeparatePlaceCount() {
        return separatePlaceCount;
    }

    public void setSeparatePlaceCount(Double separatePlaceCount) {
        this.separatePlaceCount = separatePlaceCount;
    }

    public AccountScoreFactors withSeparatePlaceCount(Double separatePlaceCount) {
        setSeparatePlaceCount(separatePlaceCount);
        return this;
    }

    public Double getVcardsCount() {
        return vcardsCount;
    }

    public void setVcardsCount(Double vcardsCount) {
        this.vcardsCount = vcardsCount;
    }

    public AccountScoreFactors withVcardsCount(Double vcardsCount) {
        setVcardsCount(vcardsCount);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        AccountScoreFactors that = (AccountScoreFactors) o;
        return Objects.equals(broadmatchPercent, that.broadmatchPercent)
                && Objects.equals(showsDaysCount, that.showsDaysCount)
                && Objects.equals(stopDaysFine, that.stopDaysFine)
                && Objects.equals(avgBannersCount, that.avgBannersCount)
                && Objects.equals(avgPhrasesCount, that.avgPhrasesCount)
                && Objects.equals(sitelinksPercent, that.sitelinksPercent)
                && Objects.equals(imagesPercent, that.imagesPercent)
                && Objects.equals(ctxPriceCoefPercent, that.ctxPriceCoefPercent)
                && Objects.equals(separatePlaceCount, that.separatePlaceCount)
                && Objects.equals(vcardsCount, that.vcardsCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                broadmatchPercent,
                showsDaysCount,
                stopDaysFine,
                avgBannersCount,
                avgPhrasesCount,
                sitelinksPercent,
                imagesPercent,
                ctxPriceCoefPercent,
                separatePlaceCount,
                vcardsCount
        );
    }
}
