package ru.yandex.direct.core.entity.account.score.service;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.common.collect.Iterables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.account.score.model.AccountScore;
import ru.yandex.direct.core.entity.account.score.repository.AccountScoreRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;

import static java.util.Collections.singletonList;

@Service
public class AccountScoreService {

    private final ShardHelper shardHelper;
    private final AccountScoreRepository accountScoreRepository;

    @Autowired
    public AccountScoreService(ShardHelper shardHelper, AccountScoreRepository accountScoreRepository) {
        this.shardHelper = shardHelper;
        this.accountScoreRepository = accountScoreRepository;
    }

    @Nullable
    public AccountScore getAccountScore(ClientId clientId) {
        return Iterables.getFirst(massGetLatestAccountScore(singletonList(clientId)), null);
    }

    @Nonnull
    public List<AccountScore> getLatestAndPreviewsAccountScore(Long clientId) {
        return accountScoreRepository.getLatestAndPreviewsAccountScore(
                shardHelper.getShardByClientId(ClientId.fromLong(clientId)), ClientId.fromLong(clientId));
    }

    @Nonnull
    public List<AccountScore> massGetLatestAccountScore(Collection<ClientId> clientIds) {
        return shardHelper.groupByShard(clientIds, ShardKey.CLIENT_ID).stream()
                .map(e -> accountScoreRepository.fetchLatestByClientIds(e.getKey(), e.getValue()))
                .toFlatList(Function.identity());
    }

}
