package ru.yandex.direct.core.entity.addition.callout.container;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;

import ru.yandex.direct.core.entity.addition.callout.model.CalloutsStatusModerate;

/**
 * Описание критериев выборки Callout'ов
 */
@ParametersAreNonnullByDefault
public final class CalloutSelection {
    @Nullable
    private List<Long> ids;
    @Nullable
    private Set<CalloutsStatusModerate> statuses;
    @Nullable
    private LocalDateTime lastChangeGreaterOrEqualThan;
    @Nullable
    private Boolean deleted;

    public CalloutSelection() {
    }

    @Nullable
    public List<Long> getIds() {
        return ids;
    }

    @Nullable
    public Set<CalloutsStatusModerate> getStatuses() {
        return statuses;
    }

    @Nullable
    public LocalDateTime getLastChangeGreaterOrEqualThan() {
        return lastChangeGreaterOrEqualThan;
    }

    @Nullable
    public Boolean getDeleted() {
        return deleted;
    }

    public boolean hasIds() {
        return ids != null && !ids.isEmpty();
    }

    public boolean hasStatuses() {
        return statuses != null && !statuses.isEmpty();
    }

    public boolean hasLastChangeGreaterThan() {
        return lastChangeGreaterOrEqualThan != null;
    }

    public boolean hasDeleted() {
        return deleted != null;
    }

    public CalloutSelection withIds(List<Long> ids) {
        this.ids = ids;
        return this;
    }

    public CalloutSelection withStatuses(Set<CalloutsStatusModerate> statuses) {
        this.statuses = statuses;
        return this;
    }

    public CalloutSelection withStatuses(CalloutsStatusModerate... statuses) {
        this.statuses = Sets.immutableEnumSet(Arrays.asList(statuses));
        return this;
    }

    public CalloutSelection withLastChangeGreaterOrEqualThan(@Nullable LocalDateTime lastChangeGreaterOrEqualThan) {
        this.lastChangeGreaterOrEqualThan = lastChangeGreaterOrEqualThan;
        return this;
    }

    public CalloutSelection withDeleted(@Nullable Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public enum State {
        ON,
        DELETED
    }
}
