package ru.yandex.direct.core.entity.addition.callout.service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.addition.callout.model.Callout;
import ru.yandex.direct.core.entity.addition.callout.repository.CalloutRepository;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class CalloutAddOperation extends SimpleAbstractAddOperation<Callout, Long> {

    private final CalloutRepository calloutRepository;
    private final CalloutValidationService calloutValidationService;

    private final int shard;
    private final ClientId clientId;

    @Autowired
    public CalloutAddOperation(Applicability applicability,
                               List<Callout> models,
                               CalloutRepository calloutRepository,
                               CalloutValidationService calloutValidationService, int shard, ClientId clientId) {
        super(applicability, models);
        this.calloutRepository = calloutRepository;
        this.calloutValidationService = calloutValidationService;
        this.shard = shard;
        this.clientId = clientId;
    }

    @Override
    protected void validate(ValidationResult<List<Callout>, Defect> preValidationResult) {
        new ItemValidationBuilder<>(preValidationResult)
                .checkBy(callouts -> calloutValidationService.validate(clientId, callouts));
    }

    @Override
    protected void beforeExecution(Map<Integer, Callout> validModelsMapToApply) {
        validModelsMapToApply.forEach((index, callout) -> {
            LocalDateTime now = LocalDateTime.now();
            callout.withCreateTime(now)
                    .withLastChange(now)
                    .withDeleted(false);
        });
    }

    @Override
    protected List<Long> execute(List<Callout> validModelsToApply) {
        return calloutRepository.add(shard, validModelsToApply);
    }
}
