package ru.yandex.direct.core.entity.addition.callout.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface CalloutDefectTranslations extends TranslationBundle {

    CalloutDefectTranslations INSTANCE = I18NBundle.implement(CalloutDefectTranslations.class);

    @MessageFormatStub("В тексте уточнений можно использовать только буквы латинского, турецкого, русского, украинского, белорусского или казахского алфавита, знаки пунктуации, за исключением !,?")
    Translatable notAllowedSymbolsInCalloutText();

    @MessageFormatStub("Превышено количество уточнений ({0})")
    Translatable maxCalloutsOnClient(Number max);

    @MessageFormatStub("Превышено общее количество уточнений ({0})")
    Translatable maxCalloutsOnClientWithDeleted(Number max);

    @MessageFormatStub("Уточнения должны быть уникальны")
    Translatable duplicateCalloutTexts();

    @MessageFormatStub("Расширение уже существует")
    Translatable adExtensionAlreadyExists();

    @MessageFormatStub("Расширение {0}")
    Translatable adExtensionId(String adExtensionId);

    @MessageFormatStub("Указанное расширение используется и не может быть удалено")
    Translatable adExtensionIsInUse();

    @MessageFormatStub("Id уточнения присутствует в запросе более одного раза")
    Translatable duplicateCalloutId();

    @MessageFormatStub("Указано пустое значение")
    Translatable emptyValue();

    @MessageFormatStub("Не указан текст уточнения")
    Translatable calloutTextNotSpecified();

    @MessageFormatStub("Превышена допустимая длина текста одного уточнения ('{0}') в {1} символов")
    Translatable calloutTextLengthExceeded(String text, int maxLength);

    @MessageFormatStub("Разрешено удалять не более {0} уточнений в одном запросе")
    Translatable deleteMaxIdsDetailed(Identity max);

    @MessageFormatStub("Расширение не найдено")
    Translatable adExtensionNotFound();

}
