package ru.yandex.direct.core.entity.addition.callout.service.validation;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class CalloutDefinitions {

    private CalloutDefinitions() {
    }

    public static Defect allowedSymbolsCalloutText() {
        return new Defect<>(CalloutDefectIds.Strings.ALLOWED_SYMBOLS_CALLOUT_TEXT);
    }

    public static Defect duplicateCalloutTexts() {
        return new Defect<>(CalloutDefectIds.Gen.DUPLICATE_CALLOUT_TEXTS);
    }

    public static Defect maxClientCallouts() {
        return new Defect<>(CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS,
                new NumberDefectParams().withMax(CalloutConstants.MAX_CALLOUTS_COUNT_ON_CLIENT));
    }

    public static Defect maxClientCalloutsWithDeleted() {
        return new Defect<>(CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS_WITH_DELETED,
                new NumberDefectParams().withMax(CalloutConstants.MAX_CALLOUTS_COUNT_ON_CLIENT_WITH_DELETED));
    }

    public static Defect adExtensionAlreadyExists() {
        return new Defect<>(CalloutDefectIds.Gen.AD_EXTENSION_ALREADY_EXISTS);
    }

    public static Defect calloutTextIsEmpty() {
        return new Defect<>(CalloutDefectIds.Gen.CALLOUT_TEXT_IS_EMPTY);
    }

    public static Defect calloutTextLengthExceeded() {
        return new Defect<>(CalloutDefectIds.Strings.CALLOUT_TEXT_LENGTH_EXCEEDED);
    }


    public static Defect adExtensionIsInUse() {
        return new Defect<>(CalloutDefectIds.Gen.AD_EXTENSION_IS_IN_USE);
    }

    public static Defect adExtensionIsDeleted() {
        return new Defect<>(CalloutDefectIds.Gen.AD_EXTENSION_IS_DELETED);
    }
}

