package ru.yandex.direct.core.entity.addition.converter;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.addition.model.AdditionsModerateType;
import ru.yandex.direct.core.entity.addition.model.ModerateAdditions;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class AdditionConverter {

    public static List<ModerateAdditions> toModerateAdditions(boolean moderateAccept, Collection<Long> calloutIds) {
        AdditionsModerateType moderateType = moderateAccept ? AdditionsModerateType.AUTO : AdditionsModerateType.PRE;
        return mapList(calloutIds, id -> new ModerateAdditions()
                .withId(id)
                .withModerateType(moderateType));
    }

}
