package ru.yandex.direct.core.entity.additionaltargetings.model

import ru.yandex.direct.dbschema.ppc.tables.records.CampAdditionalTargetingsRecord
import java.time.LocalDateTime

data class CampAdditionalTargeting(
    val id: Long,
    val cid: Long,
    val data: String,
    val createTime: LocalDateTime?,
    val comment: String?
) {
    companion object {
        fun fromRecord(
            rec: CampAdditionalTargetingsRecord
        ) = CampAdditionalTargeting(rec.id, rec.cid, rec.data, rec.createTime, rec.comment)

        fun builder() = Builder()

        class Builder {
            var id: Long? = null
            var cid: Long? = null
            var data: String? = null
            var createTime: LocalDateTime? = null
            var comment: String? = null

            fun withId(id: Long): Builder {
                this.id = id
                return this
            }

            fun withCid(cid: Long): Builder {
                this.cid = cid
                return this
            }

            fun withData(data: String): Builder {
                this.data = data
                return this
            }

            fun withCreateTime(createTime: LocalDateTime): Builder {
                this.createTime = createTime
                return this
            }

            fun withComment(comment: String): Builder {
                this.comment = comment
                return this
            }

            fun build() = CampAdditionalTargeting(id!!, cid!!, data!!, createTime!!, comment)
        }
    }
}
