package ru.yandex.direct.core.entity.additionaltargetings.model

import ru.yandex.direct.dbschema.ppc.tables.records.ClientAdditionalTargetingsRecord
import java.time.LocalDateTime

data class ClientAdditionalTargeting(
    val id: Long,
    val clientId: Long,
    val data: String,
    val createTime: LocalDateTime,
    val comment: String?
) {
    companion object {
        fun fromRecord(
            rec: ClientAdditionalTargetingsRecord
        ) = ClientAdditionalTargeting(rec.id, rec.clientid, rec.data, rec.createTime, rec.comment)

        fun builder() = Builder()

        class Builder {
            var id: Long? = null
            var clientId: Long? = null
            var data: String? = null
            var createTime: LocalDateTime? = null
            var comment: String? = null

            fun withId(id: Long): Builder {
                this.id = id
                return this
            }

            fun withClientId(clientId: Long): Builder {
                this.clientId = clientId
                return this
            }

            fun withData(data: String): Builder {
                this.data = data
                return this
            }

            fun withCreateTime(createTime: LocalDateTime): Builder {
                this.createTime = createTime
                return this
            }

            fun withComment(comment: String): Builder {
                this.comment = comment
                return this
            }

            fun build() = ClientAdditionalTargeting(id!!, clientId!!, data!!, createTime!!, comment)
        }
    }
}
