package ru.yandex.direct.core.entity.adgeneration;

import java.util.Set;


import one.util.streamex.StreamEx;

public final class ZenDomain {
    private static final Set<String> ZEN_DOMAINS = Set.of(
            "zen.yandex.ru",
            "zen.yandex.com",
            "zenadservices.net",
            "dzen.ya.ru",
            "dzen.yandex.ru",
            "main.zdevx.yandex.ru",
            "www.zen.yandex.az",
            "www.zen.yandex.by",
            "www.zen.yandex.co.il",
            "www.zen.yandex.com.am",
            "www.zen.yandex.com.ge",
            "www.zen.yandex.com.tr",
            "www.zen.yandex.ee",
            "www.zen.yandex.fr",
            "www.zen.yandex.kg",
            "www.zen.yandex.kz",
            "www.zen.yandex.lt",
            "www.zen.yandex.lv",
            "www.zen.yandex.md",
            "www.zen.yandex.tj",
            "www.zen.yandex.tm",
            "www.zen.yandex.ua",
            "www.zen.yandex.uz",
            "yabro1.zen-test.yandex.ru",
            "yabro2.zen-test.yandex.ru",
            "yabro3.zen-test.yandex.ru",
            "yabro4.zen-test.yandex.ru",
            "yabro5.zen-test.yandex.ru",
            "zen.ya.ru",
            "zen.yandex",
            "zen.yandex.az",
            "zen.yandex.by",
            "zen.yandex.co.il",
            "zen.yandex.com.am",
            "zen.yandex.com.ge",
            "zen.yandex.com.tr",
            "zen.yandex.ee",
            "zen.yandex.fr",
            "zen.yandex.kg",
            "zen.yandex.kz",
            "zen.yandex.lt",
            "zen.yandex.lv",
            "zen.yandex.md",
            "zen.yandex.tj",
            "zen.yandex.tm",
            "zen.yandex.ua",
            "zen.yandex.uz"
    );

    private ZenDomain() {
        throw new UnsupportedOperationException();
    }

    public static boolean isZenDomain(String url) {
        return StreamEx.of(ZEN_DOMAINS).anyMatch(url::contains);
    }
}
