package ru.yandex.direct.core.entity.adgeneration.model;

import javax.annotation.Nullable;

import ru.yandex.direct.imagesearch.model.AbstractImage;
import ru.yandex.direct.richcontent.model.Image;

public class ImageSuggest {
    @Nullable
    private Integer height;
    @Nullable
    private Integer width;
    @Nullable
    private String url;
    @Nullable
    private SourceInfo sourceInfo;

    private ImageSuggest() {}

    public ImageSuggest(AbstractImage source) {
        height = source.getHeight();
        width = source.getWidth();
        url = formatUrl(source.getUrl());
    }

    public ImageSuggest(Image source) {
        height = source.getHeight();
        width = source.getWidth();
        url = formatUrl(source.getUrl());
    }

    private static String formatUrl(String url) {
        if (url == null || url.startsWith("http")) {
            return url;
        } else if (url.startsWith("//")) {
            return "http:" + url;
        } else {
            return "http://" + url;
        }
    }

    @Nullable
    public String getUrl() {
        return url;
    }

    @Nullable
    public Integer getHeight() {
        return height;
    }

    @Nullable
    public Integer getWidth() {
        return width;
    }

    @Nullable
    public SourceInfo getSourceInfo() {
        return sourceInfo;
    }

    public ImageSuggest withSourceInfo(int mainTexts, int additionalTexts) {
        sourceInfo = new SourceInfo(mainTexts, additionalTexts);
        return this;
    }

    public ImageSuggest withSourceInfo(boolean isRCAByUrl, boolean isRCAByDomain) {
        sourceInfo = new SourceInfo(isRCAByUrl, isRCAByDomain);
        return this;
    }

    static class SourceInfo {
        @Nullable
        private Integer mainTexts = 0;
        @Nullable
        private Integer additionalTexts = 0;
        @Nullable
        private Integer richContentByUrl = 0;
        @Nullable
        private Integer richContentByDomain = 0;

        private SourceInfo() {}

        private SourceInfo(int mainTexts, int additionalTexts) {
            this.mainTexts = mainTexts;
            this.additionalTexts = additionalTexts;
        }

        private SourceInfo(boolean isRichContentByUrl, boolean isRichContentByDomain) {
            this.richContentByUrl = isRichContentByUrl ? 1 : 0;
            this.richContentByDomain = isRichContentByDomain ? 1 : 0;
        }

        @Nullable
        public Integer getMainTexts() {
            return mainTexts;
        }

        @Nullable
        public Integer getAdditionalTexts() {
            return additionalTexts;
        }

        @Nullable
        public Integer getRichContentByUrl() {
            return richContentByUrl;
        }

        @Nullable
        public Integer getRichContentByDomain() {
            return richContentByDomain;
        }
    }
}
