package ru.yandex.direct.core.entity.adgeneration.model;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.regions.Region;

public class RegionSuggest {

    @Nullable
    private Set<String> sources = new HashSet<>();
    private final long regionId;
    private final int regionType;
    private double weight = 1.0;

    @JsonCreator
    private RegionSuggest(
            @JsonProperty("regionId") long regionId,
            @JsonProperty("regionType") int regionType
    ) {
        this.regionId = regionId;
        this.regionType = regionType;
    }

    public RegionSuggest(Region region) {
        regionId = region.getId();
        regionType = region.getType();
    }

    public double getWeight() {
        return weight;
    }

    @Nullable
    public Set<String> getSources() {
        return sources;
    }

    public long getRegionId() {
        return regionId;
    }

    public int getRegionType() {
        return regionType;
    }

    public RegionSuggest multiWeight(double multiplier) {
        weight *= multiplier;
        return this;
    }

    public RegionSuggest addSource(String source) {
        sources.add(source);
        return this;
    }

    public boolean merge(RegionSuggest other) {
        if (getRegionId() != other.getRegionId()) {
            return false;
        }
        if (weight > 1.0 || other.getWeight() > 1.0) {
            return false;
        }
        // Мультипликативное сложение.
        // Если weight - вероятность, с которой источник уверен, что рекомендация пригодится,
        // и если предположить что источники независимы,
        // то итоговая вероятность как раз по такой формуле и считается.
        weight = 1 - (1 - weight) * (1 - other.getWeight());
        sources.addAll(other.getSources());
        return true;
    }

}
