package ru.yandex.direct.core.entity.adgeneration.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.bangenproxy.client.model.TextInfoCombinatorics;

@ParametersAreNonnullByDefault
public final class TextSuggest {
    @Nullable
    private final List<String> titles;

    @Nullable
    private final List<String> bodies;

    @Nullable
    private final String algVersion;

    public TextSuggest(List<String> titles, List<String> bodies, String algVersion) {
        this.titles = titles;
        this.bodies = bodies;
        this.algVersion = algVersion;
    }

    @Nullable
    public List<String> getTitles() {
        return titles;
    }

    @Nullable
    public List<String> getBodies() {
        return bodies;
    }

    @Nullable
    public String getAlgVersion() {
        return algVersion;
    }

    public static TextSuggest fromTextInfoCombinatorics(TextInfoCombinatorics textInfo) {
        return new TextSuggest(textInfo.getTitle(), textInfo.getBody(), textInfo.getAlgVersion());
    }
}
