package ru.yandex.direct.core.entity.adgeneration.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ZenSuggest {
    @Nullable
    private final String publisherId;

    @Nullable
    private final String publisherItemId;

    private final TextSuggest textSuggest;

    private final List<String> images;

    private final ZenCounter counter;

    public ZenSuggest(String publisherId,
                      String publisherItemId,
                      TextSuggest textSuggest,
                      List<String> images,
                      ZenCounter counter) {
        this.publisherId = publisherId;
        this.publisherItemId = publisherItemId;
        this.textSuggest = textSuggest;
        this.images = images;
        this.counter = counter;
    }

    @Nullable
    public String getPublisherId() {
        return publisherId;
    }

    @Nullable
    public String getPublisherItemId() {
        return publisherItemId;
    }

    public TextSuggest getTextSuggest() {
        return textSuggest;
    }

    public List<String> getImages() {
        return images;
    }

    public ZenCounter getCounter() {
        return counter;
    }
}
