package ru.yandex.direct.core.entity.adgeneration.region;

import java.util.HashMap;
import java.util.Map;

public class InputContainer {

    public static final String SHARD = "SHARD";
    public static final String CAMPAIGN_ID = "CAMPAIGN_ID";
    public static final String PERMALINK_ID = "PERMALINK_ID";
    public static final String COUNTER_IDS = "COUNTER_IDS";
    public static final String URL = "URL";

    private final Map<String, Object> map = new HashMap<>();

    public <T> T get(String key) {
        return (T) map.get(key);
    }

    public boolean has(String key) {
        return map.containsKey(key);
    }

    // Используем value=null, чтобы просигнализировать что не удалось вычислить значение и не нужно тратить время
    // на повторные попытки вычисления
    public InputContainer put(String key, Object value) {
        map.put(key, value);
        return this;
    }

}
