package ru.yandex.direct.core.entity.adgeneration.region;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgeneration.model.RegionSuggest;
import ru.yandex.direct.core.entity.region.repository.RegionRepository;
import ru.yandex.direct.geobasehelper.GeoBaseHelper;
import ru.yandex.direct.regions.GeoTreeFactory;
import ru.yandex.direct.regions.Region;
import ru.yandex.direct.result.Result;

import static ru.yandex.direct.core.entity.adgeneration.GenerationUtils.successResult;

@Service
@ParametersAreNonnullByDefault
public class RegionByDefaultSource extends AbstractRegionSource {

    public static final String DEFAULT_SOURCE = "default";

    @Autowired
    public RegionByDefaultSource(
            RegionRepository regionRepository,
            GeoTreeFactory geoTreeFactory,
            GeoBaseHelper geoBaseHelper
    ) {
        super(regionRepository, geoTreeFactory, geoBaseHelper);
    }

    public String getRegionSourceName() {
        return DEFAULT_SOURCE;
    }

    @Override
    protected Result<Collection<RegionSuggest>> generateRegionsInternal(InputContainer input) {
        return successResult(
                StreamEx.of(
                        Region.MOSCOW_REGION_ID,
                        Region.SAINT_PETERSBURG_REGION_ID,
                        Region.RUSSIA_REGION_ID
                ).map(
                        regionId -> new RegionSuggest(findRegion(regionId))
                ).toList());
    }
}
