package ru.yandex.direct.core.entity.adgeneration.region;

import java.util.ArrayList;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgeneration.model.RegionSuggest;
import ru.yandex.direct.core.entity.geo.service.CurrentGeoService;
import ru.yandex.direct.core.entity.region.repository.RegionRepository;
import ru.yandex.direct.geobasehelper.GeoBaseHelper;
import ru.yandex.direct.regions.GeoTreeFactory;
import ru.yandex.direct.regions.Region;
import ru.yandex.direct.result.Result;

import static ru.yandex.direct.core.entity.adgeneration.GenerationUtils.successResult;

@Service
@ParametersAreNonnullByDefault
public class RegionByOperatorSource extends AbstractRegionSource {

    public static final String OPERATOR_SOURCE = "operator";

    private final CurrentGeoService currentGeoService;

    @Autowired
    public RegionByOperatorSource(
            CurrentGeoService currentGeoService,
            RegionRepository regionRepository,
            GeoTreeFactory geoTreeFactory,
            GeoBaseHelper geoBaseHelper
    ) {
        super(regionRepository, geoTreeFactory, geoBaseHelper);
        this.currentGeoService = currentGeoService;
    }

    public String getRegionSourceName() {
        return OPERATOR_SOURCE;
    }

    @Override
    protected Result<Collection<RegionSuggest>> generateRegionsInternal(InputContainer input) {
        Long regionId = currentGeoService.getCurrentDirectRegionId().orElse(null);
        Region region = findRegion(regionId);

        Collection<RegionSuggest> suggests = new ArrayList<>();
        while (region != null && region.getId() != Region.GLOBAL_REGION_ID) {
            suggests.add(new RegionSuggest(region));
            region = region.getParent();
        }
        return successResult(suggests);
    }
}
