package ru.yandex.direct.core.entity.adgroup

import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroupWithUsersSegments
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment

class AdGroupWithUsersSegmentsHelper {
    companion object {
        @JvmStatic
        fun adGroupsWithUsersSegmentsToMap(
            adGroupsWithUsersSegments: List<AdGroupWithUsersSegments>,
        ): Map<Long, List<UsersSegment>> {
            return adGroupsWithUsersSegments.associateBy({ it.id }, { it.usersSegments })
        }

        @JvmStatic
        fun complexCpmAdGroupsToMap(
            complexCpmAdGroups: List<ComplexCpmAdGroup>,
        ): Map<Long, List<UsersSegment>> {
            return complexCpmAdGroups.associateBy({ it.adGroup.id }, { it.usersSegments })
        }
    }
}
