package ru.yandex.direct.core.entity.adgroup.container;

import java.util.Set;

import com.google.common.collect.Sets;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;

public final class AccessibleAdGroupTypes {

    public static final Set<AdGroupType> API5_ALLOWED_AD_GROUP_TYPES = Set.of(
            AdGroupType.BASE,
            AdGroupType.CONTENT_PROMOTION,
            AdGroupType.CPM_BANNER,
            AdGroupType.CPM_VIDEO,
            AdGroupType.DYNAMIC,
            AdGroupType.MOBILE_CONTENT,
            AdGroupType.PERFORMANCE);

    /**
     * Список поддерживаемых в api5 типов групп объявлений
     */
    public static final Set<ContentPromotionAdgroupType> API5_ALLOWED_CONTENT_PROMOTION_AD_GROUP_TYPES =
            Sets.immutableEnumSet(
                    ContentPromotionAdgroupType.COLLECTION,
                    ContentPromotionAdgroupType.VIDEO,
                    ContentPromotionAdgroupType.SERVICE,
                    ContentPromotionAdgroupType.EDA
            );
}
