package ru.yandex.direct.core.entity.adgroup.container;

import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;

import static com.google.common.base.Preconditions.checkState;

public class AdGroupUpdateOperationParams {

    private final boolean validateInterconnections;
    private final ModerationMode moderationMode;

    private AdGroupUpdateOperationParams(boolean validateInterconnections,
                                         ModerationMode moderationMode) {
        this.validateInterconnections = validateInterconnections;
        this.moderationMode = moderationMode;
    }

    public boolean isValidateInterconnections() {
        return validateInterconnections;
    }

    public ModerationMode getModerationMode() {
        return moderationMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean validateInterconnections;
        private ModerationMode moderationMode;

        public Builder withValidateInterconnections(boolean validateInterconnections) {
            this.validateInterconnections = validateInterconnections;
            return this;
        }

        public Builder withModerationMode(ModerationMode moderationMode) {
            this.moderationMode = moderationMode;
            return this;
        }

        public AdGroupUpdateOperationParams build() {
            checkState(validateInterconnections != null, "flag validateInterconnections must be defined");
            checkState(moderationMode != null, "moderation mode must be defined");
            return new AdGroupUpdateOperationParams(validateInterconnections, moderationMode);
        }
    }
}
