package ru.yandex.direct.core.entity.adgroup.container;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.ServingStatus;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupAppIconStatus;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupStatus;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;

import static java.util.Arrays.asList;
import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class AdGroupsSelectionCriteria {

    private Set<Long> adGroupIds;
    private Set<Long> campaignIds;
    private Set<AdGroupType> adGroupTypes;
    private Set<AdGroupStatus> adGroupStatuses;
    private Set<AdGroupAppIconStatus> adGroupAppIconStatuses;
    private Set<ServingStatus> servingStatuses;
    private Set<Long> negativeKeywordSharedSetIds;
    private Set<ContentPromotionAdgroupType> contentPromotionAdgroupTypes;

    @Nonnull
    public Set<Long> getAdGroupIds() {
        return adGroupIds == null ? emptySet() : adGroupIds;
    }

    public void setAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }

    public AdGroupsSelectionCriteria withAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public AdGroupsSelectionCriteria withAdGroupIds(Long... adGroupIds) {
        withAdGroupIds(new HashSet<>(asList(adGroupIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getCampaignIds() {
        return campaignIds == null ? emptySet() : campaignIds;
    }

    public void setCampaignIds(@Nullable Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public AdGroupsSelectionCriteria withCampaignIds(@Nullable Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public AdGroupsSelectionCriteria withCampaignIds(Long... campaignIds) {
        withCampaignIds(new HashSet<>(asList(campaignIds)));
        return this;
    }

    @Nonnull
    public Set<AdGroupType> getAdGroupTypes() {
        return adGroupTypes == null ? emptySet() : adGroupTypes;
    }

    public void setAdGroupTypes(@Nullable Set<AdGroupType> adGroupTypes) {
        this.adGroupTypes = adGroupTypes;
    }

    public AdGroupsSelectionCriteria withAdGroupTypes(@Nullable Set<AdGroupType> adGroupTypes) {
        this.adGroupTypes = adGroupTypes;
        return this;
    }

    public AdGroupsSelectionCriteria withAdGroupTypes(AdGroupType... adGroupTypes) {
        withAdGroupTypes(new HashSet<>(asList(adGroupTypes)));
        return this;
    }

    @Nonnull
    public Set<AdGroupStatus> getAdGroupStatuses() {
        return adGroupStatuses == null ? emptySet() : adGroupStatuses;
    }

    public void setAdGroupStatuses(@Nullable Set<AdGroupStatus> adGroupStatuses) {
        this.adGroupStatuses = adGroupStatuses;
    }

    public AdGroupsSelectionCriteria withAdGroupStatuses(@Nullable Set<AdGroupStatus> adGroupStatuses) {
        this.adGroupStatuses = adGroupStatuses;
        return this;
    }

    public AdGroupsSelectionCriteria withAdGroupStatuses(AdGroupStatus... adGroupStatuses) {
        withAdGroupStatuses(new HashSet<>(asList(adGroupStatuses)));
        return this;
    }

    @Nonnull
    public Set<AdGroupAppIconStatus> getAdGroupAppIconStatuses() {
        return adGroupAppIconStatuses == null ? emptySet() : adGroupAppIconStatuses;
    }

    public void setAdGroupAppIconStatuses(
            @Nullable Set<AdGroupAppIconStatus> adGroupAppIconStatuses) {
        this.adGroupAppIconStatuses = adGroupAppIconStatuses;
    }

    public AdGroupsSelectionCriteria withAdGroupAppIconStatuses(
            @Nullable Set<AdGroupAppIconStatus> adGroupAppIconStatuses) {
        this.adGroupAppIconStatuses = adGroupAppIconStatuses;
        return this;
    }

    public AdGroupsSelectionCriteria withAdGroupAppIconStatuses(AdGroupAppIconStatus... adGroupAppIconStatuses) {
        withAdGroupAppIconStatuses(new HashSet<>(asList(adGroupAppIconStatuses)));
        return this;
    }

    @Nonnull
    public Set<ServingStatus> getServingStatuses() {
        return servingStatuses == null ? emptySet() : servingStatuses;
    }

    public void setServingStatuses(@Nullable Set<ServingStatus> servingStatuses) {
        this.servingStatuses = servingStatuses;
    }

    public AdGroupsSelectionCriteria withAdGroupServingStatuses(@Nullable Set<ServingStatus> servingStatuses) {
        this.servingStatuses = servingStatuses;
        return this;
    }

    public AdGroupsSelectionCriteria withAdGroupServingStatuses(ServingStatus... servingStatuses) {
        withAdGroupServingStatuses(new HashSet<>(asList(servingStatuses)));
        return this;
    }

    @Nonnull
    public Set<Long> getNegativeKeywordSharedSetIds() {
        return negativeKeywordSharedSetIds == null ? emptySet() : negativeKeywordSharedSetIds;
    }

    public void setNegativeKeywordSharedSetIds(@Nullable Set<Long> negativeKeywordSharedSetIds) {
        this.negativeKeywordSharedSetIds = negativeKeywordSharedSetIds;
    }

    public AdGroupsSelectionCriteria withNegativeKeywordSharedSetIds(@Nullable Set<Long> negativeKeywordSharedSetIds) {
        this.negativeKeywordSharedSetIds = negativeKeywordSharedSetIds;
        return this;
    }

    public AdGroupsSelectionCriteria withNegativeKeywordSharedSetIds(Long... negativeKeywordSharedSetIds) {
        withNegativeKeywordSharedSetIds(new HashSet<>(asList(negativeKeywordSharedSetIds)));
        return this;
    }

    @Nonnull
    public Set<ContentPromotionAdgroupType> getContentPromotionAdgroupTypes() {
        return nvl(contentPromotionAdgroupTypes, emptySet());
    }

    public void setContentPromotionAdgroupTypes(
            @Nullable Set<ContentPromotionAdgroupType> contentPromotionAdgroupTypes) {
        this.contentPromotionAdgroupTypes = contentPromotionAdgroupTypes;
    }

    public AdGroupsSelectionCriteria withContentPromotionAdgroupTypes(
            @Nullable Set<ContentPromotionAdgroupType> contentPromotionAdgroupTypes) {
        this.contentPromotionAdgroupTypes = contentPromotionAdgroupTypes;
        return this;
    }



    public AdGroupsSelectionCriteria copy(AdGroupsSelectionCriteria toCopy) {
        return new AdGroupsSelectionCriteria()
                .withAdGroupIds(toCopy.getAdGroupIds())
                .withCampaignIds(toCopy.getCampaignIds())
                .withAdGroupTypes(toCopy.getAdGroupTypes())
                .withAdGroupStatuses(toCopy.getAdGroupStatuses())
                .withAdGroupAppIconStatuses(toCopy.getAdGroupAppIconStatuses())
                .withAdGroupServingStatuses(toCopy.getServingStatuses());
    }
}
