package ru.yandex.direct.core.entity.adgroup.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.operation.Applicability;

@ParametersAreNonnullByDefault
public final class InternalAdGroupOperationContainer {
    private final UidAndClientId owner;
    private final long operatorUid;
    private final Applicability applicability;
    private final boolean saveDraft;
    private final RequestSource requestSource;

    /**
     * @param applicability применимость операции в зависимости от результатов валидации
     * @param operatorUid   uid оператора
     * @param owner         идентификаторы клиента
     * @param saveDraft     нужно ли сохранять черновик
     * @param requestSource Источник запроса (пригодится для определения какие таргетинги не надо перезатирать)
     */
    public InternalAdGroupOperationContainer(Applicability applicability, long operatorUid, UidAndClientId owner,
                                             boolean saveDraft,
                                             RequestSource requestSource) {
        this.applicability = applicability;
        this.operatorUid = operatorUid;
        this.owner = owner;
        this.saveDraft = saveDraft;
        this.requestSource = requestSource;
    }

    public boolean isSaveDraft() {
        return saveDraft;
    }

    public long getOperatorUid() {
        return operatorUid;
    }

    public Applicability getApplicability() {
        return applicability;
    }

    public UidAndClientId getOwner() {
        return owner;
    }

    public RequestSource getRequestSource() {
        return requestSource;
    }

    public enum RequestSource {
        FRONT,
        EXCEL
    }
}
