package ru.yandex.direct.core.entity.adgroup.model;

/**
 * Наличие групп типов {@link AdGroupType#CPM_GEOPRODUCT} и {@link AdGroupType#CPM_GEO_PIN} в кампании.
 */
public enum GeoproductAvailability {
    /**
     * В кампании есть хотя бы одна группа типа {@link AdGroupType#CPM_GEOPRODUCT} или {@link AdGroupType#CPM_GEO_PIN}.
     */
    YES,
    /**
     * В кампании нет ни одной группы типа {@link AdGroupType#CPM_GEOPRODUCT} и {@link AdGroupType#CPM_GEO_PIN}.
     */
    NO,
    /**
     * В кампании нет ни одной группы.
     */
    EMPTY;


    public static GeoproductAvailability convert(Boolean anyGeoProduct) {
        if (anyGeoProduct == null) {
            return EMPTY;
        }
        return anyGeoProduct ? YES : NO;
    }
}
