package ru.yandex.direct.core.entity.adgroup.repository;

import java.util.List;
import java.util.function.Function;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusautobudgetshow;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.direct.utils.JsonUtils;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public final class AdGroupMappings {
    private AdGroupMappings() {
    }

    public static PhrasesStatusautobudgetshow statusAutobudgetShowToDb(Boolean statusAutobudgetShow) {
        if (statusAutobudgetShow == null) {
            return null;
        }
        return statusAutobudgetShow ? PhrasesStatusautobudgetshow.Yes : PhrasesStatusautobudgetshow.No;
    }

    public static Boolean statusAutobudgetShowFromDb(PhrasesStatusautobudgetshow statusAutobudgetShow) {
        if (statusAutobudgetShow == null) {
            return null;
        }
        return statusAutobudgetShow == PhrasesStatusautobudgetshow.Yes;
    }

    public static PhrasesStatusbssynced statusBsSyncedToDb(StatusBsSynced statusBsSynced) {
        return statusBsSynced != null ?
                PhrasesStatusbssynced.valueOf(capitalize(statusBsSynced.name().toLowerCase())) : null;
    }

    public static StatusBsSynced statusBsSyncedFromDb(PhrasesStatusbssynced statusBsSynced) {
        return statusBsSynced != null ?
                StatusBsSynced.valueOf(statusBsSynced.name().toUpperCase()) : null;
    }

    public static String geoToDb(List<Long> geo) {
        return geo != null ? StringUtils.join(geo, ",") : null;
    }

    public static List<Long> geoFromDb(String geo) {
        Function<String, List<Long>> converter =
                geo1 -> StreamEx.split(geo1, ",").map(Long::valueOf).toList();
        return geo != null ? converter.apply(geo) : null;
    }

    public static String pageGroupTagsToDb(@Nullable List<String> pageGroupTags) {
        return RepositoryUtils.nullSafeWrapper(JsonUtils::toJson).apply(pageGroupTags);
    }

    public static List<String> pageGroupTagsFromDb(@Nullable String jsonPageGroupTags) {
        return jsonPageGroupTags == null ? emptyList() : asList(fromJson(jsonPageGroupTags, String[].class));
    }

    public static String targetTagsToDb(@Nullable List<String> targetTags) {
        return RepositoryUtils.nullSafeWrapper(JsonUtils::toJson).apply(targetTags);
    }

    public static List<String> targetTagsFromDb(@Nullable String jsonTargetTags) {
        return jsonTargetTags == null ? emptyList() : asList(fromJson(jsonTargetTags, String[].class));
    }

}
