package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.Map;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmAudioAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmGeoPinAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmGeoproductAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmIndoorAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmOutdoorAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmVideoAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmYndxFrontpageAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.McBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.model.ModelChanges;

import static com.google.common.base.Preconditions.checkState;
import static java.lang.String.format;
import static java.util.Map.entry;

public class AdGroupTypesMapper {
    private AdGroupTypesMapper() {
    }

    // TODO разобраться куда маппить AdGroupType.DYNAMIC и CPM_PRICE
    private final static Map<AdGroupType, Class<? extends AdGroup>> AD_GROUP_TYPE_TO_CLASS = Map.ofEntries(
            entry(AdGroupType.CPM_PRICE, AdGroup.class),
            entry(AdGroupType.DYNAMIC, DynamicAdGroup.class),
            entry(AdGroupType.BASE, TextAdGroup.class),
            entry(AdGroupType.INTERNAL, InternalAdGroup.class),
            entry(AdGroupType.CPM_BANNER, CpmBannerAdGroup.class),
            entry(AdGroupType.CPM_VIDEO, CpmVideoAdGroup.class),
            entry(AdGroupType.CPM_AUDIO, CpmAudioAdGroup.class),
            entry(AdGroupType.MCBANNER, McBannerAdGroup.class),
            entry(AdGroupType.CONTENT_PROMOTION, ContentPromotionAdGroup.class),
            entry(AdGroupType.CPM_GEOPRODUCT, CpmGeoproductAdGroup.class),
            entry(AdGroupType.CPM_GEO_PIN, CpmGeoPinAdGroup.class),
            entry(AdGroupType.CPM_YNDX_FRONTPAGE, CpmYndxFrontpageAdGroup.class),
            entry(AdGroupType.CPM_OUTDOOR, CpmOutdoorAdGroup.class),
            entry(AdGroupType.CPM_INDOOR, CpmIndoorAdGroup.class),
            entry(AdGroupType.PERFORMANCE, PerformanceAdGroup.class),
            entry(AdGroupType.MOBILE_CONTENT, MobileContentAdGroup.class)
    );

    public static <T extends AdGroup> ModelChanges<T> getTypedEmptyModelChanges(AdGroupType type, Long id) {
        Class<? extends AdGroup> targetClass = getClassByAdGroupType(type);
        checkState(AdGroup.class.isAssignableFrom(targetClass), "Class AdGroup can't be assigned from %s", targetClass);
        //noinspection unchecked
        Class<T> targetClassTyped = (Class<T>) targetClass;
        return new ModelChanges<>(id, targetClassTyped);
    }

    private static Class<? extends AdGroup> getClassByAdGroupType(AdGroupType type) {
        if (!AD_GROUP_TYPE_TO_CLASS.containsKey(type)) {
            throw new UnsupportedOperationException(
                    format("Ad group of type %s are not supported", type.name()));
        }
        return AD_GROUP_TYPE_TO_CLASS.get(type);
    }
}
