package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.common.jooqmapper.OldJooqMapper;
import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate;
import ru.yandex.direct.core.entity.adgroup.model.StatusShowsForecast;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupMappings;
import ru.yandex.direct.core.entity.mapping.CommonMappings;
import ru.yandex.direct.core.entity.minuskeywordspack.MinusKeywordsPackUtils;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupsDynamicStatusblgenerated;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupsTextStatusblgenerated;
import ru.yandex.direct.dbschema.ppc.tables.AdgroupBsTags;
import ru.yandex.direct.dbschema.ppc.tables.AdgroupProjectParams;
import ru.yandex.direct.dbschema.ppc.tables.GroupParams;
import ru.yandex.direct.dbschema.ppc.tables.Phrases;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.StringUtils.isEmpty;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.common.jooqmapperex.FieldMapperFactoryEx.booleanField;
import static ru.yandex.direct.common.jooqmapperex.FieldMapperFactoryEx.timestampField;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_HYPERGEO_RETARGETINGS;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_BS_TAGS;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_PROJECT_PARAMS;
import static ru.yandex.direct.dbschema.ppc.Tables.GROUP_PARAMS;
import static ru.yandex.direct.dbschema.ppc.Tables.MINUS_WORDS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;

@ParametersAreNonnullByDefault
public class Common {
    private Common() {
    }

    public static final OldJooqMapper<AdGroup> ADGROUP_MAPPER_FOR_COMMON_FIELDS =
            new OldJooqMapperBuilder<AdGroup>()
                    .map(field(PHRASES.PID, AdGroup.ID))
                    .map(field(PHRASES.CID, AdGroup.CAMPAIGN_ID))
                    .map(convertibleField(PHRASES.ADGROUP_TYPE, AdGroup.TYPE)
                            .convertToDbBy(AdGroupType::toSource)
                            .convertFromDbBy(AdGroupType::fromSource))
                    .map(field(PHRASES.GROUP_NAME, AdGroup.NAME))
                    .map(field(PHRASES.PRIORITY_ID, AdGroup.PRIORITY_ID)
                            .withDefaultValueForDb(0L))
                    .map(convertibleField(PHRASES.STATUS_BS_SYNCED, AdGroup.STATUS_BS_SYNCED)
                            .convertToDbBy(AdGroupMappings::statusBsSyncedToDb)
                            .convertFromDbBy(AdGroupMappings::statusBsSyncedFromDb)
                            .withDatabaseDefault())
                    .map(convertibleField(PHRASES.STATUS_MODERATE, AdGroup.STATUS_MODERATE)
                            .convertToDbBy(StatusModerate::toSource)
                            .convertFromDbBy(StatusModerate::fromSource)
                            .withDatabaseDefault())
                    .map(convertibleField(PHRASES.STATUS_POST_MODERATE, AdGroup.STATUS_POST_MODERATE)
                            .convertToDbBy(StatusPostModerate::toSource)
                            .convertFromDbBy(StatusPostModerate::fromSource)
                            .withDatabaseDefault())
                    .map(field(PHRASES.MW_ID, AdGroup.MINUS_KEYWORDS_ID))
                    .map(convertibleField(PHRASES.GEO, AdGroup.GEO)
                            .convertToDbBy(AdGroupMappings::geoToDb)
                            .convertFromDbBy(AdGroupMappings::geoFromDb))
                    .map(convertibleField(PHRASES.STATUS_AUTOBUDGET_SHOW, AdGroup.STATUS_AUTOBUDGET_SHOW)
                            .convertToDbBy(AdGroupMappings::statusAutobudgetShowToDb)
                            .convertFromDbBy(AdGroupMappings::statusAutobudgetShowFromDb)
                            .withDatabaseDefault())
                    .map(convertibleField(PHRASES.STATUS_SHOWS_FORECAST, AdGroup.STATUS_SHOWS_FORECAST)
                            .convertToDbBy(StatusShowsForecast::toSource)
                            .convertFromDbBy(StatusShowsForecast::fromSource)
                            .withDatabaseDefault())
                    .map(timestampField(PHRASES.FORECAST_DATE, AdGroup.FORECAST_DATE)
                            .withDatabaseDefault())
                    .map(timestampField(PHRASES.LAST_CHANGE, AdGroup.LAST_CHANGE)
                            .withDatabaseDefault())
                    .map(convertibleField(PHRASES.IS_BS_RARELY_LOADED, AdGroup.BS_RARELY_LOADED)
                            .convertFromDbBy(RepositoryUtils::booleanFromLong)
                            .disableWritingToDb()
                            .withDatabaseDefault())

                    // также читаем минус-фразы из таблицы minus_words
                    .map(convertibleField(MINUS_WORDS.MW_TEXT, AdGroup.MINUS_KEYWORDS)
                            .convertFromDbBy(MinusKeywordsPackUtils::minusKeywordsFromJson)
                            .disableWritingToDb())
                    // group_params
                    .map(field(GROUP_PARAMS.PID, AdGroup.ID).disableReadingFromDb())
                    .map(booleanField(GROUP_PARAMS.HAS_PHRASEID_HREF, AdGroup.HAS_PHRASE_ID_HREF)
                            .disableWritingToDb())
                    .map(convertibleField(GROUP_PARAMS.HREF_PARAMS, AdGroup.TRACKING_PARAMS)
                            .convertToDbBy(val -> isEmpty(val) ? null : val)
                            .convertFromDbBy(val -> isEmpty(val) ? null : val))

                    // adgroup_bs_tags
                    .map(field(ADGROUP_BS_TAGS.PID, AdGroup.ID).disableReadingFromDb())
                    .map(convertibleField(ADGROUP_BS_TAGS.PAGE_GROUP_TAGS_JSON, AdGroup.PAGE_GROUP_TAGS)
                            .convertToDbBy(AdGroupMappings::pageGroupTagsToDb)
                            .convertFromDbBy(AdGroupMappings::pageGroupTagsFromDb))
                    .map(convertibleField(ADGROUP_BS_TAGS.TARGET_TAGS_JSON, AdGroup.TARGET_TAGS)
                            .convertToDbBy(AdGroupMappings::targetTagsToDb)
                            .convertFromDbBy(AdGroupMappings::targetTagsFromDb))

                    // adgroup_project_params
                    .map(field(ADGROUP_PROJECT_PARAMS.PID, AdGroup.ID).disableReadingFromDb())
                    .map(convertibleField(ADGROUP_PROJECT_PARAMS.PROJECT_PARAM_CONDITIONS,
                            AdGroup.PROJECT_PARAM_CONDITIONS)
                            .convertToDbBy(CommonMappings::longListToDbJsonFormat)
                            .convertFromDbBy(CommonMappings::longListFromDbJsonFormat))

                    // adgroups_hypergeo_retargetings
                    .map(field(ADGROUPS_HYPERGEO_RETARGETINGS.RET_COND_ID, AdGroup.HYPER_GEO_ID))

                    .buildWithoutModelSupplier();

    /**
     * Добавляет группы в таблицы, общие для всех типов, например, в ppc.phrases
     */
    static void addAdGroupsToCommonTables(DSLContext dslContext, List<? extends AdGroup> adGroups) {
        InsertHelper.saveModelObjectsToDbTable(dslContext, Phrases.PHRASES, ADGROUP_MAPPER_FOR_COMMON_FIELDS, adGroups);

        InsertHelper.saveModelObjectsToDbTable(dslContext, GroupParams.GROUP_PARAMS, ADGROUP_MAPPER_FOR_COMMON_FIELDS,
                adGroups.stream()
                        .filter(adGroup ->
                                adGroup.getTrackingParams() != null && !adGroup.getTrackingParams().isEmpty())
                        .collect(toList()));

        InsertHelper.saveModelObjectsToDbTable(dslContext, AdgroupBsTags.ADGROUP_BS_TAGS,
                ADGROUP_MAPPER_FOR_COMMON_FIELDS,
                adGroups.stream()
                        .filter(adGroup ->
                                adGroup.getPageGroupTags() != null && !adGroup.getPageGroupTags().isEmpty() ||
                                        adGroup.getTargetTags() != null && !adGroup.getTargetTags().isEmpty())
                        .collect(toList()));

        InsertHelper.saveModelObjectsToDbTable(dslContext, AdgroupProjectParams.ADGROUP_PROJECT_PARAMS,
                ADGROUP_MAPPER_FOR_COMMON_FIELDS,
                adGroups.stream()
                        .filter(adGroup -> adGroup.getProjectParamConditions() != null &&
                                !adGroup.getProjectParamConditions().isEmpty())
                        .collect(toList()));
    }

    // TODO: Временный костыль для DIRECT-155321, уберём при окончательном объединении смартов и ДО
    @Deprecated
    @Nullable
    public static AdgroupsDynamicStatusblgenerated statusBLGeneratedToDbAdgroupsDynamic(@Nullable StatusBLGenerated value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case NO:
                return AdgroupsDynamicStatusblgenerated.No;
            case PROCESSING:
                return AdgroupsDynamicStatusblgenerated.Processing;
            case YES:
                return AdgroupsDynamicStatusblgenerated.Yes;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Deprecated
    @Nullable
    public static StatusBLGenerated statusBLGeneratedFromDbAdgroupsDynamic(@Nullable AdgroupsDynamicStatusblgenerated value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case No:
                return StatusBLGenerated.NO;
            case Processing:
                return StatusBLGenerated.PROCESSING;
            case Yes:
                return StatusBLGenerated.YES;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    // TODO: Костыль для DIRECT-157241, когда-нибудь уберем...
    @Deprecated
    @Nullable
    public static AdgroupsTextStatusblgenerated statusBLGeneratedToDbAdgroupsText(@Nullable StatusBLGenerated value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case NO:
                return AdgroupsTextStatusblgenerated.No;
            case PROCESSING:
                return AdgroupsTextStatusblgenerated.Processing;
            case YES:
                return AdgroupsTextStatusblgenerated.Yes;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Deprecated
    @Nullable
    public static StatusBLGenerated statusBLGeneratedFromDbAdgroupsText(@Nullable AdgroupsTextStatusblgenerated value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case No:
                return StatusBLGenerated.NO;
            case Processing:
                return StatusBLGenerated.PROCESSING;
            case Yes:
                return StatusBLGenerated.YES;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
