package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionVideoAdGroup;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

/**
 * Реализация логики работы с группой типа CONTENT_PROMOTION_VIDEO в репозиториях:
 * сохранение группы в базу, чтение группы из базы
 */
@Component
@ParametersAreNonnullByDefault
public class ContentPromotionVideoAdGroupSupport implements AdGroupTypeSupport<ContentPromotionVideoAdGroup> {

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.CONTENT_PROMOTION_VIDEO;
    }

    @Override
    public Class<ContentPromotionVideoAdGroup> getAdGroupClass() {
        return ContentPromotionVideoAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId,
                                            List<ContentPromotionVideoAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
    }

    @Override
    public ContentPromotionVideoAdGroup constructInstanceFromDb(Record record) {
        ContentPromotionVideoAdGroup adGroup = new ContentPromotionVideoAdGroup();
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
