package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.CpmAudioAdGroup;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.AdGroupWithUsersSegmentsHelper.adGroupsWithUsersSegmentsToMap;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

@Component
@ParametersAreNonnullByDefault
public class CpmAudioAdGroupSupport extends CpmPriceSalesAdGroupSupport implements AdGroupTypeSupport<CpmAudioAdGroup>  {

    private final UsersSegmentService usersSegmentService;

    @Autowired
    public CpmAudioAdGroupSupport(UsersSegmentService usersSegmentService) {
        this.usersSegmentService = usersSegmentService;
    }

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.CPM_AUDIO;
    }

    @Override
    public Class<CpmAudioAdGroup> getAdGroupClass() {
        return CpmAudioAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId, List<CpmAudioAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
        usersSegmentService.addSegments(dslContext, adGroupsWithUsersSegmentsToMap(adGroups));
        addPriorities(dslContext, adGroups);
    }

    @Override
    public CpmAudioAdGroup constructInstanceFromDb(Record record) {
        CpmAudioAdGroup adGroup = new CpmAudioAdGroup();
        ADGROUP_MAPPER_FOR_PRICE_SALES_ADGROUP_FIELDS.fromDb(record, adGroup);
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
