package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.CpmGeoPinAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.internal.AdGroupBsTagsRepository;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

@Component
@ParametersAreNonnullByDefault
public class CpmGeoPinAdGroupSupport implements AdGroupTypeSupport<CpmGeoPinAdGroup> {

    private final AdGroupBsTagsRepository adGroupBsTagsRepository;

    public CpmGeoPinAdGroupSupport(AdGroupBsTagsRepository adGroupBsTagsRepository) {
        this.adGroupBsTagsRepository = adGroupBsTagsRepository;
    }

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.CPM_GEO_PIN;
    }

    @Override
    public Class<CpmGeoPinAdGroup> getAdGroupClass() {
        return CpmGeoPinAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId,
                                            List<CpmGeoPinAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
    }

    @Override
    public CpmGeoPinAdGroup constructInstanceFromDb(Record record) {
        CpmGeoPinAdGroup adGroup = new CpmGeoPinAdGroup();
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
