package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.CpmGeoproductAdGroup;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

@Component
@ParametersAreNonnullByDefault
public class CpmGeoproductAdGroupSupport implements AdGroupTypeSupport<CpmGeoproductAdGroup> {

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.CPM_GEOPRODUCT;
    }

    @Override
    public Class<CpmGeoproductAdGroup> getAdGroupClass() {
        return CpmGeoproductAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId,
                                            List<CpmGeoproductAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
    }

    @Override
    public CpmGeoproductAdGroup constructInstanceFromDb(Record record) {
        CpmGeoproductAdGroup adGroup = new CpmGeoproductAdGroup();
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
