package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;
import java.util.stream.Collectors;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupPriceSales;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_PRIORITY;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

public abstract class CpmPriceSalesAdGroupSupport {
    public static final JooqMapper<AdGroupPriceSales> ADGROUP_MAPPER_FOR_PRICE_SALES_ADGROUP_FIELDS
            = JooqMapperBuilder.<AdGroupPriceSales>builder()
            .map(property(AdGroupPriceSales.ID, ADGROUP_PRIORITY.PID))
            .map(property(AdGroupPriceSales.PRIORITY, ADGROUP_PRIORITY.PRIORITY))
            .build();

    protected static <T extends AdGroupPriceSales> void addPriorities(DSLContext dslContext, List<T> adGroups) {
        List<T> adGroupsWithNotNullPriority = adGroups.stream()
                .filter(ad -> ad.getPriority() != null)
                .collect(Collectors.toList());
        new InsertHelper<>(dslContext, ADGROUP_PRIORITY)
                .addAll(ADGROUP_MAPPER_FOR_PRICE_SALES_ADGROUP_FIELDS, adGroupsWithNotNullPriority)
                .executeIfRecordsAdded();
    }
}
