package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.CpmYndxFrontpageAdGroup;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

@Component
@ParametersAreNonnullByDefault
public class CpmYndxFrontpageAdGroupSupport extends CpmPriceSalesAdGroupSupport implements AdGroupTypeSupport<CpmYndxFrontpageAdGroup> {

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.CPM_YNDX_FRONTPAGE;
    }

    @Override
    public Class<CpmYndxFrontpageAdGroup> getAdGroupClass() {
        return CpmYndxFrontpageAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId,
                                            List<CpmYndxFrontpageAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
        addPriorities(dslContext, adGroups);
    }

    @Override
    public CpmYndxFrontpageAdGroup constructInstanceFromDb(Record record) {
        CpmYndxFrontpageAdGroup adGroup = new CpmYndxFrontpageAdGroup();
        ADGROUP_MAPPER_FOR_PRICE_SALES_ADGROUP_FIELDS.fromDb(record, adGroup);
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
