package ru.yandex.direct.core.entity.adgroup.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.McBannerAdGroup;
import ru.yandex.direct.dbutil.model.ClientId;

import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;

@Component
@ParametersAreNonnullByDefault
public class McBannerAdGroupSupport implements AdGroupTypeSupport<McBannerAdGroup> {
    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.MCBANNER;
    }

    @Override
    public Class<McBannerAdGroup> getAdGroupClass() {
        return McBannerAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId, List<McBannerAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
    }

    @Override
    public McBannerAdGroup constructInstanceFromDb(Record record) {
        McBannerAdGroup adGroup = new McBannerAdGroup();
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(adGroup, record);
        return adGroup;
    }
}
