package ru.yandex.direct.core.entity.adgroup.repository.typesupport;


import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.jooqmapper.OldJooqMapper;
import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.PerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.dbschema.ppc.tables.records.AdgroupsPerformanceRecord;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.jooqmapperhelper.JooqUpdateBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.ADGROUP_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroup.repository.typesupport.Common.addAdGroupsToCommonTables;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_PERFORMANCE;

@Component
@ParametersAreNonnullByDefault
public class PerformanceAdGroupSupport implements AdGroupTypeSupport<PerformanceAdGroup> {

    public static final OldJooqMapper<PerformanceAdGroup> ADGROUP_MAPPER_FOR_PERFORMANCE_FIELDS =
            new OldJooqMapperBuilder<PerformanceAdGroup>()
                    .map(field(ADGROUPS_PERFORMANCE.PID, PerformanceAdGroup.ID).disableReadingFromDb())
                    .map(field(ADGROUPS_PERFORMANCE.FEED_ID, PerformanceAdGroup.FEED_ID))
                    .map(convertibleField(ADGROUPS_PERFORMANCE.STATUS_BL_GENERATED,
                            PerformanceAdGroup.STATUS_B_L_GENERATED)
                            .convertToDbBy(StatusBLGenerated::toSource)
                            .convertFromDbBy(StatusBLGenerated::fromSource)
                            .withDatabaseDefault())
                    .map(field(ADGROUPS_PERFORMANCE.FIELD_TO_USE_AS_NAME, PerformanceAdGroup.FIELD_TO_USE_AS_NAME))
                    .map(field(ADGROUPS_PERFORMANCE.FIELD_TO_USE_AS_BODY, PerformanceAdGroup.FIELD_TO_USE_AS_BODY))
                    .buildWithoutModelSupplier();

    @Override
    public AdGroupType adGroupType() {
        return AdGroupType.PERFORMANCE;
    }

    @Override
    public Class<PerformanceAdGroup> getAdGroupClass() {
        return PerformanceAdGroup.class;
    }

    @Override
    public void addAdGroupsToDatabaseTables(DSLContext dslContext, ClientId clientId,
                                            List<PerformanceAdGroup> adGroups) {
        addAdGroupsToCommonTables(dslContext, adGroups);
        List<PerformanceAdGroup> performanceAdGroups = StreamEx.of(adGroups)
                .select(PerformanceAdGroup.class)
                .toList();
        addToAdGroupsPerformance(dslContext, performanceAdGroups);
    }

    private void addToAdGroupsPerformance(DSLContext dslContext, List<PerformanceAdGroup> performanceAdGroups) {
        performanceAdGroups.forEach(p -> checkArgument(p.getFeedId() != null));
        new InsertHelper<>(dslContext, ADGROUPS_PERFORMANCE)
                .addAll(ADGROUP_MAPPER_FOR_PERFORMANCE_FIELDS, performanceAdGroups)
                .executeIfRecordsAdded();
    }

    @Override
    public PerformanceAdGroup constructInstanceFromDb(Record record) {
        PerformanceAdGroup result = new PerformanceAdGroup();
        ADGROUP_MAPPER_FOR_COMMON_FIELDS.fromDb(result, record);
        ADGROUP_MAPPER_FOR_PERFORMANCE_FIELDS.fromDb(result, record);
        return result;
    }

    @Override
    public void updateAdGroups(Collection<AppliedChanges<PerformanceAdGroup>> adGroups, ClientId clientId,
                               DSLContext dslContext) {
        updatePerformanceAdGroups(adGroups, dslContext);
    }

    private void updatePerformanceAdGroups(Collection<AppliedChanges<PerformanceAdGroup>> groups,
                                           DSLContext dslContext) {
        JooqUpdateBuilder<AdgroupsPerformanceRecord, PerformanceAdGroup> updateBuilder =
                new JooqUpdateBuilder<>(ADGROUPS_PERFORMANCE.PID, groups);

        updateBuilder.processProperty(PerformanceAdGroup.FEED_ID, ADGROUPS_PERFORMANCE.FEED_ID);
        updateBuilder.processProperty(
                PerformanceAdGroup.STATUS_B_L_GENERATED,
                ADGROUPS_PERFORMANCE.STATUS_BL_GENERATED,
                StatusBLGenerated::toSource);
        updateBuilder
                .processProperty(PerformanceAdGroup.FIELD_TO_USE_AS_NAME, ADGROUPS_PERFORMANCE.FIELD_TO_USE_AS_NAME);
        updateBuilder
                .processProperty(PerformanceAdGroup.FIELD_TO_USE_AS_BODY, ADGROUPS_PERFORMANCE.FIELD_TO_USE_AS_BODY);

        dslContext
                .update(ADGROUPS_PERFORMANCE)
                .set(updateBuilder.getValues())
                .where(ADGROUPS_PERFORMANCE.PID.in(updateBuilder.getChangedIds()))
                .execute();
    }
}
