package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Map;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class AdGroupCpmPriceUtils {

    public static final Long PRIORITY_DEFAULT = 0L;
    public static final Long PRIORITY_SPECIFIC = 10L;

    private AdGroupCpmPriceUtils() {
    }

    /**
     *  Возвращает является ли группа дефолтной группой в прайсовой кампании.
     *  Важно передать правильную мапу приоритетов - в ней должны быть группы только прайсовых кампаний.
     */
    public static Predicate<Long> isDefaultAdGroup(Map<Long, Long> cpmPriceAdgroupPriorities) {
        return adGroupId -> isDefaultPriority(cpmPriceAdgroupPriorities.get(adGroupId));
    }

    public static boolean isDefaultPriority(Long priority) {
        return PRIORITY_DEFAULT.equals(priority);
    }

    public static boolean isSpecificPriority(Long priority) {
        return PRIORITY_SPECIFIC.equals(priority);
    }
}
