package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeo;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegment;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Хэлпер для {@link AdGroupsAddOperation} и {@link AdGroupsUpdateOperation}. Содержит методы, которые должны быть
 * применены на каком-то этапе операции, но реализацию которых не хотелось бы видеть в самих операциях.
 */
@Component
@ParametersAreNonnullByDefault
public class AdGroupOperationsHelper {

    @Autowired
    public AdGroupOperationsHelper() {
    }

    void fillHyperGeoSegmentIds(Collection<AdGroup> adGroups,
                                Map<Long, HyperGeo> hyperGeoById) {
        StreamEx.of(adGroups)
                .filter(adGroup -> Objects.nonNull(adGroup.getHyperGeoId()))
                .forEach(adGroup -> fillHyperGeoSegmentIds(adGroup, hyperGeoById));
    }

    void setHyperRegionGoalIdsForChanges(Collection<AppliedChanges<AdGroup>> adGroupsAppliedChanges,
                                         Map<Long, HyperGeo> hyperGeoById) {
        adGroupsAppliedChanges.stream()
                .filter(ch -> ch.changedAndNotDeleted(AdGroup.HYPER_GEO_ID))
                .map(AppliedChanges::getModel)
                .forEach(adGroup -> fillHyperGeoSegmentIds(adGroup, hyperGeoById));
    }

    private void fillHyperGeoSegmentIds(AdGroup adGroup,
                                        Map<Long, HyperGeo> hyperGeoById) {
        Long hyperGeoId = adGroup.getHyperGeoId();
        HyperGeo hyperGeo = hyperGeoById.get(hyperGeoId);
        adGroup.setHyperGeoSegmentIds(mapList(hyperGeo.getHyperGeoSegments(), HyperGeoSegment::getId));
    }
}
